<?php
$font       = __DIR__ . '/arialbd.ttf';
$basePath   = __DIR__ . '/base.png';
$outputDir  = __DIR__ . '/../testes/';
$domainFile = __DIR__ . '/domain.txt';
$stretchMax = 1.5; // stretch vertikal maksimal
$paddingLR  = 15;  // padding kiri-kanan

// buat folder output kalau belum ada
if (!is_dir($outputDir)) mkdir($outputDir, 0777, true);

// load base
$baseOriginal = imagecreatefrompng($basePath);
imagesavealpha($baseOriginal, true);

$baseW = imagesx($baseOriginal);
$baseH = imagesy($baseOriginal);

// box vertikal (teks agak ke bawah)
$boxY1 = intval($baseH * 0.3); 
$boxY2 = intval($baseH * 0.95);
$boxH  = $boxY2 - $boxY1;
$boxW  = $baseW - ($paddingLR * 2); // box width dikurangi padding

// font proporsional
$fontSizeMax = intval($boxH * 1.25); // mulai jauh lebih besar
$fontSizeMin = intval($boxH * 0.70); // batas minimum lebih besar

// baca domain.txt
$domains = file($domainFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$generated = 0;

foreach ($domains as $text) {
    $text = trim($text);
    if ($text === '') continue;

    $safeName = preg_replace('/[^a-zA-Z0-9\-_\.]/', '_', $text);
    $filename = $outputDir . $safeName . '.webp';

    $base = imagecreatefrompng($basePath);
    imagesavealpha($base, true);

    // 🔥 Auto resize font agar teks tidak nembus
    $currentFont = $fontSizeMax;
    do {
        $bbox = imagettfbbox($currentFont, 0, $font, strtoupper($text));
        $textW = $bbox[2] - $bbox[0];
        if ($textW <= $boxW) break;
        $currentFont -= 2;
    } while ($currentFont >= $fontSizeMin);

    // render teks ke canvas terpisah
    $bbox = imagettfbbox($currentFont, 0, $font, strtoupper($text));
    $textW = $bbox[2] - $bbox[0];
    $textH = $bbox[1] - $bbox[7];

    $textCanvas = imagecreatetruecolor($textW + 50, $textH + 50);
    imagesavealpha($textCanvas, true);
    $transparent = imagecolorallocatealpha($textCanvas, 0, 0, 0, 127);
    imagefill($textCanvas, 0, 0, $transparent);

    $outline = imagecolorallocate($textCanvas, 246, 189, 55);
    $textColor = imagecolorallocate($textCanvas, 252, 209, 118);

    $ox = 25;
    $oy = $textH + 25;

    // outline
    for ($dx = -3; $dx <= 3; $dx++) {
        for ($dy = -3; $dy <= 3; $dy++) {
            if ($dx !== 0 || $dy !== 0) {
                imagettftext($textCanvas, $currentFont, 0, $ox + $dx, $oy + $dy, $outline, $font, strtoupper($text));
            }
        }
    }

    // teks utama
    imagettftext($textCanvas, $currentFont, 0, $ox, $oy, $textColor, $font, strtoupper($text));

    // vertical stretch
    $tW = imagesx($textCanvas);
    $tH = imagesy($textCanvas);
    $stretch = min($stretchMax, $boxH / $tH);
    $newH = intval($tH * $stretch);

    $stretched = imagecreatetruecolor($tW, $newH);
    imagesavealpha($stretched, true);
    $transparent2 = imagecolorallocatealpha($stretched, 0, 0, 0, 127);
    imagefill($stretched, 0, 0, $transparent2);

    imagecopyresampled($stretched, $textCanvas, 0, 0, 0, 0, $tW, $newH, $tW, $tH);

    // scale horizontal agar tidak nembus padding
    $finalTW = imagesx($stretched);
    $finalTH = imagesy($stretched);

    if ($finalTW > $boxW) {
        $scaled = imagecreatetruecolor($boxW, $finalTH);
        imagesavealpha($scaled, true);
        $transparent3 = imagecolorallocatealpha($scaled, 0, 0, 0, 127);
        imagefill($scaled, 0, 0, $transparent3);

        imagecopyresampled(
            $scaled,
            $stretched,
            0, 0,
            0, 0,
            $boxW, $finalTH,
            $finalTW, $finalTH
        );

        $stretched = $scaled;
        $finalTW = $boxW;
    }

    // posisi final (dengan padding kiri)
    $finalX = $paddingLR; 
    $finalY = $boxY1 + intval(($boxH - $finalTH) / 2);

    imagecopy($base, $stretched, $finalX, $finalY, 0, 0, $finalTW, $finalTH);

    // simpan
    if (file_exists($filename)) unlink($filename);
    imagewebp($base, $filename, 100);

    echo "✔ Terbuat: $filename<br>";
    $generated++;

    imagedestroy($base);
}

echo "<br><b>Selesai generate $generated logo.</b>";
?>
