from selenium import webdriver
import time, os, re, requests, urllib.parse, hashlib

URL = "https://mol777.org"
FOLDER = r"C:\Users\ev\Videos\toko kosong\ini project baru\test"

ALLOWED_EXT = (".png", ".webp", ".gif", ".svg", ".woff", ".woff2", ".ttf", ".eot")
os.makedirs(FOLDER, exist_ok=True)

driver = webdriver.Chrome()
driver.get(URL)
time.sleep(5)

downloaded_urls = set()
downloaded_hashes = set()

# -----------------------
# Fungsi utilitas
# -----------------------
def file_hash_bytes(data):
    return hashlib.md5(data).hexdigest()

def save_unique(filename, content):
    h = file_hash_bytes(content)
    if h in downloaded_hashes:
        return False
    downloaded_hashes.add(h)

    path = os.path.join(FOLDER, filename)
    if os.path.exists(path):
        with open(path, "rb") as f:
            if hashlib.md5(f.read()).hexdigest() == h:
                return False
        name, ext = os.path.splitext(filename)
        i = 1
        while True:
            new_name = f"{name}_{i}{ext}"
            new_path = os.path.join(FOLDER, new_name)
            if not os.path.exists(new_path):
                path = new_path
                break
            i += 1

    with open(path, "wb") as f:
        f.write(content)
    return True

def download_url(url):
    if url in downloaded_urls:
        return
    downloaded_urls.add(url)

    if url.startswith("//"):
        url = "https:" + url
    if not url.startswith("http"):
        return

    if not url.split("?")[0].lower().endswith(ALLOWED_EXT):
        return

    filename = os.path.basename(urllib.parse.urlparse(url).path)
    if not filename:
        return

    try:
        r = requests.get(url, timeout=15)
        if r.status_code == 200 and r.content:
            if save_unique(filename, r.content):
                print("Saved:", filename)
    except:
        pass

# -----------------------
# 1️⃣ Ambil asset dari CSS/JS
# -----------------------
texts_to_scan = []

# CSS eksternal
for link in driver.find_elements("css selector", "link[rel='stylesheet']"):
    href = link.get_attribute("href")
    if href:
        try:
            css_text = requests.get(href, timeout=15).text
            texts_to_scan.append((css_text, href))
        except:
            continue

# Inline style
for style in driver.find_elements("tag name", "style"):
    css_text = style.get_attribute("innerHTML")
    if css_text:
        texts_to_scan.append((css_text, URL if URL.endswith("/") else URL+"/"))

# JS eksternal
for script in driver.find_elements("tag name", "script"):
    src = script.get_attribute("src")
    if src:
        try:
            js_text = requests.get(src, timeout=15).text
            texts_to_scan.append((js_text, src))
        except:
            continue

# Regex untuk ambil semua url(...)
url_pattern = re.compile(r'url\(["\']?(.*?)["\']?\)')

for text, base_url in texts_to_scan:
    for match in url_pattern.findall(text):
        if match.startswith("data:"):
            continue
        full_url = urllib.parse.urljoin(base_url, match)
        download_url(full_url)

# -----------------------
# 2️⃣ Ambil asset dari HTML <img> / <amp-img>
# -----------------------
for el in driver.find_elements("css selector", "img, amp-img"):
    src = (
        el.get_attribute("src")
        or el.get_attribute("data-src")
        or el.get_attribute("data-original")
    )
    srcset = el.get_attribute("srcset")
    if srcset:
        # ambil URL terakhir di srcset (biasanya resolusi tertinggi)
        src = srcset.split(",")[-1].split()[0]

    if not src:
        continue
    if src.startswith("//"):
        src = "https:" + src

    download_url(src)

driver.quit()
